document.addEventListener('DOMContentLoaded', () => {
    const leftPane = document.getElementById('leftPane');
    const middlePane = document.getElementById('middlePane');
    if (!leftPane || !middlePane) return;

    const closeBtn = leftPane.querySelector('#closeDepositHistoryBtn');
    if (closeBtn) {
        closeBtn.addEventListener('click', () => {
            window.location.href = '/undepositedfunds';
        });
    }

    leftPane.addEventListener('click', async (e) => {
        const item = e.target.closest('.deposit-item');
        if (!item) return;
        const id = item.dataset.id;
        try {
            const resp = await fetch(`/deposithistory/loadView?pane=middle&id=${id}`);
            const html = await resp.text();
            middlePane.innerHTML = html;
            leftPane.querySelectorAll('.deposit-item').forEach(el => el.classList.remove('active'));
            item.classList.add('active');
        } catch (err) {
            console.error('Error loading deposit', err);
        }
    });
});
