<?php /* app/Views/layouts/main.php — Triple Pane Shell */ ?>

<?= $this->include('template-parts/header') ?>

<!-- Triple-pane layout core CSS -->
<link rel="stylesheet" href="<?= base_url('css/layouts/main/main.css') ?>">

<main class="container-fluid p-0">
    <div id="splitWrapper" class="split-wrapper">

        <!-- LEFT PANE -->
        <section id="leftPane" class="split-pane">
            <?= $this->renderSection('left') ?>
        </section>

        <!-- LEFT VERTICAL RESIZER -->
        <div id="leftResizer" class="resizer"></div>

        <!-- MIDDLE PANE -->
        <section id="middlePane" class="split-pane">
            <?= $this->renderSection('middle') ?>
        </section>

        <!-- RIGHT VERTICAL RESIZER -->
        <div id="rightResizer" class="resizer"></div>

        <!-- RIGHT PANE (off-screen by default) -->
        <section id="rightPane" class="split-pane">
            <?= $this->renderSection('right') ?>
        </section>

    </div>
</main>

<!-- Progress overlay for pulling QuickBooks data -->
<div id="pullProgressOverlay">
    <div class="text-center">
        <div class="spinner-border text-light" role="status"></div>
        <div class="message">
            Pulled <span id="pullCount">0</span> items...
        </div>
    </div>
</div>

<!-- All JS scripts go here, before closing body tag -->
<script src="<?= base_url('/js/app.js') ?>"></script>
<script src="<?= base_url('/js/layouts/main/main.js') ?>"></script>
<script src="<?= base_url('/js/manage_undeposited_funds/manage_undeposited_funds.js') ?>"></script>
<script src="<?= base_url('/js/deposit_history/deposit_history.js') ?>"></script>

<?= $this->include('template-parts/footer') ?>
</body>
</html>
