<?php
namespace App\Models;

use CodeIgniter\Model;

class DepositHistoryModel extends Model
{
    protected $table      = 'deposits_made';
    protected $primaryKey = 'id';
    protected $returnType = 'array';
    protected $DBGroup    = 'default';

    public function getAllDeposits(): array
    {
        return $this->orderBy('deposit_date', 'DESC')->findAll();
    }

    public function getDepositWithLines(int $id): array
    {
        $header = $this->where('id', $id)->first();
        if (! $header) {
            return ['deposit' => null, 'lines' => []];
        }

        $db = db_connect();
        $lines = $db->table('deposits_made_lines')
                    ->where('deposits_made_id', $id)
                    ->orderBy('line_num', 'ASC')
                    ->get()
                    ->getResultArray();

        return ['deposit' => $header, 'lines' => $lines];
    }
}
