<?php /* app/Views/layouts/main.php — Triple Pane Shell */ ?>

<?= $this->include('template-parts/header') ?>

<!-- Triple-pane layout core CSS -->
<link rel="stylesheet" href="<?= base_url('css/layouts/main/main.css') ?>">

<main class="container-fluid p-0">
    <div id="splitWrapper" class="split-wrapper">

        <!-- LEFT PANE -->
        <section id="leftPane" class="split-pane">
            <?= $this->renderSection('left') ?>
        </section>

        <!-- LEFT VERTICAL RESIZER -->
        <div id="leftResizer" class="resizer"></div>

        <!-- MIDDLE PANE -->
        <section id="middlePane" class="split-pane">
            <?= $this->renderSection('middle') ?>
        </section>

        <!-- RIGHT VERTICAL RESIZER -->
        <div id="rightResizer" class="resizer"></div>

        <!-- RIGHT PANE (off-screen by default) -->
        <section id="rightPane" class="split-pane">
            <?= $this->renderSection('right') ?>
        </section>

    </div>
</main>

<!-- Main pane shell JS -->
<script src="<?= base_url('js/layouts/main/main.js') ?>"></script>

<script>
// This script assumes you use AJAX to load content into panes.
// When "Make Bank Deposit" is clicked, it loads both panes accordingly.
document.addEventListener('DOMContentLoaded', () => {
    const splitWrapper = document.getElementById('splitWrapper');

    // Listen for clicks on "Make Bank Deposit" button anywhere in the app
    splitWrapper.addEventListener('click', function(e) {
        const btn = e.target.closest('#makeBankDepositBtn');
        if (!btn) return;

        // Load new middle pane (Make Bank Deposit)
        fetch('<?= base_url('undepositedfunds/loadView') ?>?pane=middle&view=make_bank_deposit')
            .then(res => res.text())
            .then(html => {
                document.getElementById('middlePane').innerHTML = html;
            });

        // Load new left pane (Make Bank Deposit Sidebar)
        fetch('<?= base_url('undepositedfunds/loadView') ?>?pane=left&view=make_bank_deposit')
            .then(res => res.text())
            .then(html => {
                document.getElementById('leftPane').innerHTML = html;
            });
    });
});
</script>

<?= $this->include('template-parts/footer') ?>
