<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\BbtApiModel;

/**
 * PullDealCustomOptionsAPI
 *
 * Follows the same chunked approach as your other pull controllers,
 * e.g. PullQbSalesReceiptsAPI and PullDealsAPI.
 */
class PullDealCustomOptionsAPI extends Controller
{
    public function index()
    {
        // 1) Prepare local model
        $model = new BbtApiModel();

        // 2) Find the highest local ID in bbt_subdeal_custom_options
        $maxLocalId = $model->getMaxSubdealCustomOptionsId();  // new method in BbtApiModel

        // 3) Calculate our start ID as "highest local ID - 700" (but never < 0)
        $startId = $maxLocalId - 700;
        if ($startId < 0) {
            $startId = 0;
        }

        // 4) Define our chunk size
        $chunkSize = 100;

        // 5) Loop until no more data is returned
        while (true) {
            // a) Calculate this chunk's end ID
            $endId = $startId + $chunkSize - 1;

            // b) Make the remote request for ONLY that ID range
            $client = \Config\Services::curlrequest();
            $response = $client->request('GET', 'https://brechbilltools.com/index.php/admin/WillisPlaygroundAPI/getSubdealCustomOptionsDataByIdRange', [
                'headers' => [
                    'X-API-KEY' => 'YOUR_API_KEY_HERE',  // same key as your other pulls
                ],
                'query' => [
                    'start_id' => $startId,
                    'end_id'   => $endId,
                ],
            ]);

            // c) Decode the JSON
            $chunkData = json_decode($response->getBody(), true);

            // d) If the returned data is empty, we’re done
            if (empty($chunkData)) {
                break;
            }

            // e) Upsert the chunk into the local DB (similar to upsertDeals, upsertQbSalesReceipts, etc.)
            $model->upsertSubdealCustomOptions($chunkData);

            // f) Move to the next chunk
            $startId = $endId + 1;
        }

        // 6) Return JSON response indicating success
        return $this->response->setJSON([
            'status'  => 'success',
            'message' => 'Subdeal Custom Options data synced successfully using the last 700 ID logic.',
        ]);
    }
}
