<?php
/**
 * layouts/navbar.php
 *
 * This partial expects a variable $menuItems (an array of objects),
 * each having 'name', 'url', and optionally 'is_admin', etc.
 */
?>

<nav class="main-header navbar navbar-expand my-navbar">
  <!-- Right-side: Example "Sign In" link -->
  <ul class="navbar-nav ml-auto">
    <li class="nav-item">
      <a class="nav-link" href="<?= base_url('/login') ?>">
        <i class="fa fa-sign-in-alt mr-2"></i> Sign In
      </a>
    </li>
  </ul>
</nav>

<aside class="main-sidebar my-sidebar elevation-4">
  <!-- Sidebar toggler -->
  <div class="sidebar-hamburger mt-2 ml-2">
    <a class="nav-link" href="#" role="button">
      <i class="fas fa-bars"></i>
    </a>
  </div>

  <div class="sidebar">
    <!-- Dynamic menu items -->
    <?php if (! empty($menuItems) && is_array($menuItems)): ?>
      <ul class="nav flex-column">
        <?php foreach ($menuItems as $item): ?>
          <li class="nav-item">
            <!-- Use the 'url' field for the link target -->
            <a class="nav-link" href="<?= base_url($item->url) ?>">
              <?= esc($item->name) ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php else: ?>
      <!-- Fallback if no items are found -->
      <p class="p-3">No menu items found</p>
    <?php endif; ?>
  </div>
</aside>

<script>
  // Optional: Script to collapse/expand the sidebar
  document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggler = document.querySelector('.sidebar-hamburger a.nav-link');
    if (sidebarToggler) {
      sidebarToggler.addEventListener('click', function(e) {
        e.preventDefault();
        document.querySelector('aside.main-sidebar')
          .classList.toggle('collapsed');
      });
    }
  });
</script>
