<?php

namespace App\Controllers;

use App\Models\ConversationModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Home extends BaseController
{
    public function index()
    {
        // Fetch latest conversations in descending order to pass to the navbar
        $conversationModel = new ConversationModel();
        $conversations = $conversationModel->orderBy('id', 'DESC')->findAll();

        return view('home/index', [
            'page' => 'home',
            'conversations' => $conversations, // Pass ordered conversations data to the view
        ]);
    }

    // ... existing methods ...
}
