<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Original routes commented out for potential reversion
/*
$routes->get('/', 'Home::index');
$routes->add('/user/', 'User::index');
$routes->add('/user/(:any)', 'User::$1');
$routes->add('/(:any)', 'Home::$1');
*/

// Current routes setup
$routes->get('/', 'Home::index'); // Default route for Home
$routes->add('/user/', 'User::index'); // Route for user index
$routes->add('/user/(:any)', 'User::$1'); // Route for user methods

// Routes for GPT Connection
$routes->get('/category/gpt_connection', 'Gpt_connection::index'); // Route for Gpt_connection
$routes->get('/gpt', 'Gpt_connection::index'); // Route for /gpt pointing to the same controller

// Wildcard route for Home (placed at the end)
$routes->add('/(:any)', 'Home::$1');

$routes->post('/gpt_connection/submit', 'Gpt_connection::submit');
$routes->post('/gpt_connection/newConversation', 'Gpt_connection::newConversation');
$routes->post('/gpt_connection/editTitle/(:num)', 'Gpt_connection::editTitle/$1');

// Default routes
$routes->get('/', 'Home::index');
$routes->add('/user/', 'User::index');
$routes->add('/user/(:any)', 'User::$1');

// Routes for GPT Connection
$routes->get('/category/gpt_connection', 'Gpt_connection::index');
$routes->get('/gpt', 'Gpt_connection::index');
$routes->post('/gpt_connection/submit', 'Gpt_connection::submit');

// Routes for Conversations
$routes->get('/conversations/create', 'Conversations::create');
$routes->get('/conversations/edit/(:num)', 'Conversations::edit/$1');
$routes->post('/conversations/update/(:num)', 'Conversations::update/$1');

// Wildcard route for Home (placed at the end)
$routes->add('/(:any)', 'Home::$1');
$routes->post('conversations/delete/(:num)', 'Conversations::delete/$1');

$routes->get('/conversations/create', 'Conversations::create');
$routes->get('/conversations/view/(:num)', '\App\Controllers\Conversations::view/$1');
$routes->get('/conversations/edit/(:num)', 'Conversations::edit/$1');
$routes->post('/conversations/update/(:num)', 'Conversations::update/$1');
$routes->get('/conversations/delete/(:num)', 'Conversations::delete/$1');


$routes->post('/conversations/sendMessage', 'Conversations::sendMessage');
$routes->get('/conversations/getDoThisText/(:num)', 'Conversations::getDoThisText/$1');



