/* -------------------------------------------------------
   1) Vertical split: Left ⇄ Middle
   ------------------------------------------------------- */
(() => {
    const KEY = 'leftSplitPct';
    const leftResizer = document.getElementById('leftResizer'),
          leftPane    = document.getElementById('leftPane'),
          middlePane  = document.getElementById('middlePane'),
          wrapper     = document.getElementById('splitWrapper');

    // restore saved percentage if available
    const saved = parseFloat(localStorage.getItem(KEY));
    if (saved > 5 && saved < 90) {
        leftPane.style.flex   = `0 0 ${saved}%`;
        middlePane.style.flex = `0 0 ${100 - saved}%`;
    } else {
        // Default 33% left, 67% middle
        leftPane.style.flex   = '0 0 33.33%';
        middlePane.style.flex = '1 1 0';
    }

    let startX, startLeftWidth, currentPct = saved || 33.33;

    leftResizer.addEventListener('mousedown', e => {
        startX = e.clientX;
        startLeftWidth = leftPane.getBoundingClientRect().width;

        document.addEventListener('mousemove', drag);
        document.addEventListener('mouseup', stop);
    });

    ['dragstart','selectstart'].forEach(ev =>
        leftResizer.addEventListener(ev, e => e.preventDefault())
    );

    function drag(e) {
        const dx = e.clientX - startX;
        currentPct = ((startLeftWidth + dx) / wrapper.clientWidth) * 100;
        if (currentPct > 5 && currentPct < 90) {
            leftPane.style.flex   = `0 0 ${currentPct}%`;
            middlePane.style.flex = `0 0 ${100 - currentPct}%`;
        }
    }

    function stop() {
        document.removeEventListener('mousemove', drag);
        document.removeEventListener('mouseup', stop);
        if (currentPct > 5 && currentPct < 90) {
            localStorage.setItem(KEY, currentPct.toFixed(2));
        }
    }
})();

/* -------------------------------------------------------
   2) Right overlay: Middle ⇄ Right Pane
   ------------------------------------------------------- */
(() => {
    const KEY = 'rightPaneWidth';
    const rightPane    = document.getElementById('rightPane'),
          rightResizer = document.getElementById('rightResizer'),
          middlePane   = document.getElementById('middlePane');

    // restore saved width if available
    const savedW = parseFloat(localStorage.getItem(KEY)) || 0;
    // start hidden
    rightPane.style.flex = `0 0 ${savedW}px`;

    let startX, startWidth, newWidth = savedW;

    rightResizer.addEventListener('mousedown', e => {
        // removing transitions while dragging (optional)
        rightPane.classList.add('no-transition');

        startX = e.clientX;
        startWidth = rightPane.getBoundingClientRect().width;

        document.addEventListener('mousemove', drag);
        document.addEventListener('mouseup', stop);
    });

    ['dragstart','selectstart'].forEach(ev =>
        rightResizer.addEventListener(ev, e => e.preventDefault())
    );

    function drag(e) {
        // dragging left => increase width
        const dx = startX - e.clientX;
        newWidth = startWidth + dx;

        // If you want to limit how far it can open, set a max
        const max = window.innerWidth * 0.9;
        if (newWidth < 0)  newWidth = 0;
        if (newWidth > max) newWidth = max;

        rightPane.style.flex = `0 0 ${newWidth}px`;
    }

    function stop() {
        document.removeEventListener('mousemove', drag);
        document.removeEventListener('mouseup', stop);
        rightPane.classList.remove('no-transition');
        localStorage.setItem(KEY, newWidth.toFixed(0));
    }
})();
