<?php helper('auth'); ?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= esc($title ?? 'My Site') ?></title>
    <?= csrf_meta() ?>

    <!-- Bootstrap -->
    <link rel="stylesheet"
          href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

    <!-- Your dark theme -->
    <link rel="stylesheet" href="<?= base_url('css/app.css') ?>">

    <!-- Form/Selector CSS for the left pane -->
    <link rel="stylesheet" href="<?= base_url('css/main_view_selector/left/main_view_selector.css') ?>">
    
    <link rel="stylesheet" href="<?= base_url('css/manage_undeposited_funds/manage_undeposited_funds.css') ?>">
    <link rel="stylesheet" href="<?= base_url('css/deposit_history/deposit_history.css') ?>">
    <!-- Loading overlay styles -->
    <link rel="stylesheet" href="<?= base_url('css/loading_overlay.css') ?>">

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

</head>
<body>

<header class="navbar navbar-expand-lg navbar-dark bg-secondary shadow-sm">
    <div class="container-fluid">
        <a class="navbar-brand" href="<?= site_url() ?>">
            <img src="<?= base_url('images/icons/rkl_toolbox.png') ?>" alt="rkl ToolBox" style="height:40px;">
        </a>

        <div class="d-flex align-items-center ms-auto">
            <?php if (auth()->loggedIn()): ?>
                <?php $u = auth()->user(); ?>
                <span class="me-3"><?= esc($u->username) ?></span>
                <a class="btn btn-outline-light" href="<?= site_url('logout') ?>">Log&nbsp;out</a>
            <?php else: ?>
                <a class="btn btn-outline-light" href="<?= site_url('login') ?>">Sign&nbsp;in</a>
            <?php endif; ?>
        </div>
    </div>
</header>
