<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use League\OAuth2\Client\Provider\GenericProvider;

class QbOAuth extends Controller
{
    public function connect()
    {
        $redirectAfter = $this->request->getGet('redirect') ?? '/auditquickbooks';

        $provider = new GenericProvider([
            'clientId'                => getenv('QB_CLIENT_ID'),
            'clientSecret'            => getenv('QB_CLIENT_SECRET'),
            'redirectUri'             => getenv('QB_REDIRECT_URI'),
            'urlAuthorize'            => 'https://appcenter.intuit.com/connect/oauth2',
            'urlAccessToken'          => 'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer',
            'urlResourceOwnerDetails' => 'https://accounts.platform.intuit.com/v1/openid_connect/userinfo',
            'scopes'                  => 'com.intuit.quickbooks.accounting',
        ]);

        $authorizationUrl = $provider->getAuthorizationUrl([
            'state' => bin2hex(random_bytes(8))
        ]);

        $session = session();
        $session->set('oauth2state', $provider->getState());
        $session->set('redirect_after_connect', $redirectAfter);

        return redirect()->to($authorizationUrl);
    }

    public function callback()
    {
        $session = session();
        $savedState = $session->get('oauth2state');

        $provider = new GenericProvider([
            'clientId'                => getenv('QB_CLIENT_ID'),
            'clientSecret'            => getenv('QB_CLIENT_SECRET'),
            'redirectUri'             => getenv('QB_REDIRECT_URI'),
            'urlAuthorize'            => 'https://appcenter.intuit.com/connect/oauth2',
            'urlAccessToken'          => 'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer',
            'urlResourceOwnerDetails' => 'https://accounts.platform.intuit.com/v1/openid_connect/userinfo',
            'scopes'                  => 'com.intuit.quickbooks.accounting',
        ]);

        $incomingState = $this->request->getGet('state');
        if (empty($incomingState) || $incomingState !== $savedState) {
            return 'Error: Invalid state. Potential CSRF issue.';
        }

        $code    = $this->request->getGet('code');
        $realmId = $this->request->getGet('realmId');
        if (empty($code) || empty($realmId)) {
            return 'Error: Missing code or realmId from Intuit callback.';
        }

        try {
            $accessToken = $provider->getAccessToken('authorization_code', [
                'code' => $code
            ]);
        } catch (\Exception $e) {
            return 'Error requesting access token: ' . $e->getMessage();
        }

        $session->set([
            'realmid'       => $realmId,
            'access_token'  => $accessToken->getToken(),
            'refresh_token' => $accessToken->getRefreshToken(),
            'expires_at'    => $accessToken->getExpires()
        ]);

        $redirectAfter = $session->get('redirect_after_connect') ?? '/auditquickbooks';
        $session->remove('redirect_after_connect');

        return redirect()->to($redirectAfter);
    }
}
