In Quickbooks there is a page called "Bank Deposits". All items that exist on the page are assigned to the "undeposited funds" accont.

In quickbooks the user checks items on that page he wants to add to a deposit and the a "dposite object" is created. 


Below are 2 sets of code for the same page >>> this page is designed to recreate the "Bank Deposits" page in my own site. The end goal is to be able to check items on my version and use the QuickBooks API to create the Deposit object and add the checked items to it. 

This in turn is to now remove those checked items form the real QB's Bank Deposits page because in QB's the will now be assigned to a deposit. 


Below is the API documentation from QB's as well as some samples provided by QB

A deposit object is a transaction that records one or more deposits of the following types:
A customer payment, originally held in the Undeposited Funds account, into the Asset Account specified by the Deposit.DepositToAccountRef attribute. The Deposit.line.LinkedTxn element is used in this case to hold deposit information.
A new, direct deposit specified by Deposit.Line.DepositLineDetail line detail.
Business Rules
There must be at least one line item included in a create request.
Any transaction that funds the Undeposited Funds account can be linked to a Deposit object with a Deposit.Line.LinkedTxn element.
The deposit object
ATTRIBUTES
Id
* Required for update
read only
system defined
String , filterable , sortable
Unique identifier for this object. Sort order is ASC by default.
DepositToAccountRef
* Required
ReferenceType
Identifies the account to be used for this deposit. Query the Account name list resource to determine the appropriate Account object for this reference, where Account.AccountType is Other Current Asset or Bank. Use Account.Id and Account.Name from that object for DepositToAccountRef.value and DepostiToAccountRef.name, respectively.
Show child attributes 
Line [0..n]
* Required
Line
Individual line items comprising the deposit. Specify a Line.LinkedTxn element along with DepositLine detail type if this line is to record a deposit for an existing transaction. Select UndepositedFunds account on the existing transaction to make it available for the Deposit.
Possible types of transactions that can be linked to a Deposit include: Transfer, Payment (for Cash, CreditCard, and Check payment method types), SalesReceipt, RefundReceipt, JournalEntry.
In addition, any expense object whose line item has AccountReceivable can be linked to a Payment and then that Payment can be linked to a Deposit object.
Use Line.LinkedTxn.TxnId as the ID in a separate read request for the specific resource to retrieve details of the linked object. Valid Line types include: LinkedTxn and DepositLine
LineLinkedTxn
Show child attributes 
DepositLine
Show child attributes 
SyncToken
* Required for update
read only
system defined
String
Version number of the object. It is used to lock an object for use by one app at a time. As soon as an application modifies an object, its SyncToken is incremented. Attempts to modify an object specifying an older SyncToken fails. Only the latest version of the object is maintained by QuickBooks Online.
GlobalTaxCalculation
* Conditionally required
minorVersion: 3




GlobalTaxCalculationEnum
Method in which tax is applied. Allowed values are: TaxExcluded, TaxInclusive, and NotApplicable. Not applicable to US companies; required for non-US companies.
CurrencyRef
* Conditionally required
CurrencyRefType
Reference to the currency in which all amounts on the associated transaction are expressed. This must be defined if multicurrency is enabled for the company.
Multicurrency is enabled for the company if Preferences.MultiCurrencyEnabled is set to true. Read more about multicurrency support here. The CurrencyRef can be overwritten by the Line.DepositLineDetail Entity. If the customer that you are referring to has a default currency of USD then the currency for this Deposit will always be set as USD.
Show child attributes 
PrivateNote
Optional
max character: max of 4000 chars
String
User entered, organization-private note about the transaction. This note does not appear on the invoice to the customer. This field maps to the Memo field on the Invoice form.
ExchangeRate
Optional
Decimal
The number of home currency units it takes to equal one unit of currency specified by CurrencyRef. Applicable if multicurrency is enabled for the company.
DepartmentRef
Optional
ReferenceType
A reference to a Department object specifying the location of the transaction, as defined using location tracking in QuickBooks Online. Available if Preferences.AccountingInfoPrefs.TrackDepartments is set to true. Query the Department name list resource to determine the appropriate Department object for this reference. Use Department.Id and Department.Name from that object for DepartmentRef.value and DepartmentRef.name, respectively.
Show child attributes 
TxnSource
Optional
String
Used internally to specify originating source of a credit card transaction.
TxnDate
Optional
Date , filterable , sortable
The date entered by the user when this transaction occurred. For posting transactions, this is the posting date that affects the financial statements. If the date is not supplied, the current date on the server is used.
Sort order is ASC by default.
CashBack
Optional
CashBackInfo
Show child attributes 
TransactionLocationType
Optional
minorVersion: 4

String
The account location. Valid values include:
WithinFrance
FranceOverseas
OutsideFranceWithEU
OutsideEU
For France locales, only.
TxnTaxDetail
Optional
minorVersion: 4




TxnTaxDetail
This data type provides information for taxes charged on the transaction as a whole. It captures the details sales taxes calculated for the transaction based on the tax codes referenced by the transaction. This can be calculated by QuickBooks business logic or you may supply it when adding a transaction. See Global tax model for more information about this element. If sales tax is disabled (Preferences.TaxPrefs.UsingSalesTax is set to false) then TxnTaxDetail is ignored and not stored.
Show child attributes 
MetaData
Optional
ModificationMetaData
Descriptive information about the object. The MetaData values are set by Data Services and are read only for all applications.
Show child attributes 
RecurDataRef
read only
minorVersion: 52
ReferenceType
A reference to the Recurring Transaction. It captures what recurring transaction template the Deposit was created from.
Show child attributes 
TotalAmt
read only
system defined
BigDecimal
Indicates the total amount of the transaction. This includes the total of all the charges, allowances, and taxes. Calculated by QuickBooks business logic; any value you supply is over-written by QuickBooks.
HomeTotalAmt
read only
system defined
Decimal
Total amount of the transaction in the home currency. Includes the total of all the charges, allowances and taxes. Calculated by QuickBooks business logic. Value is valid only when CurrencyRef is specified. Applicable if multicurrency is enabled for the company.
SAMPLE OBJECT


Create a deposit
A create request includes at least one line representing a deposit--either a direct deposit or linked deposit. More than one deposit can be included in the request; types can be mixed.

A direct deposit must have at least:
-One line that specifies Deposit.Line.DepositLineDetail.AccountRef.
-The Deposit.DepositToAccountRef attribute specified.

A deposit via linked transaction must have at least:
-One line that specifies Deposit.Line.LinkedTxn.
-The Deposit.DepositToAccountRef attribute specified.
Request Body
The minimum elements to create a Deposit object are listed here.

ATTRIBUTES
CurrencyRef
* Conditionally required
CurrencyRefType
Reference to the currency in which all amounts on the associated transaction are expressed. This must be defined if multicurrency is enabled for the company.
Multicurrency is enabled for the company if Preferences.MultiCurrencyEnabled is set to true. Read more about multicurrency support here. The CurrencyRef can be overwritten by the Line.DepositLineDetail Entity. If the customer that you are referring to has a default currency of USD then the currency for this Deposit will always be set as USD.
Show child attributes 
ExchangeRate
Optional
Decimal
The number of home currency units it takes to equal one unit of currency specified by CurrencyRef. Applicable if multicurrency is enabled for the company.
DepositToAccountRef
Optional
ReferenceType
Identifies the account to be used for this deposit. Query the Account name list resource to determine the appropriate Account object for this reference, where Account.AccountType is Other Current Asset or Bank. Use Account.Id and Account.Name from that object for DepositToAccountRef.value and DepostiToAccountRef.name, respectively.
Show child attributes 
Line [0..n]
Optional
Line
Individual line items of a transaction. Valid Line types include:
DepositLine
Show child attributes 
Returns
The deposit response body.


SAMPLE OBJECT

{
  "Deposit": {
    "SyncToken": "0", 
    "domain": "QBO", 
    "DepositToAccountRef": {
      "name": "Checking", 
      "value": "35"
    }, 
    "TxnDate": "2014-12-22", 
    "TotalAmt": 1675.52, 
    "sparse": false, 
    "Line": [
      {
        "Amount": 1675, 
        "LinkedTxn": [
          {
            "TxnLineId": "0", 
            "TxnId": "120", 
            "TxnType": "Payment"
          }
        ]
      }
    ], 
    "Id": "148", 
    "MetaData": {
      "CreateTime": "2014-12-22T12:46:52-08:00", 
      "LastUpdatedTime": "2014-12-22T12:46:52-08:00"
    }
  }, 
  "time": "2014-12-22T13:39:35.449-08:00"
}

------------------------
Request URL
POST /v3/company/<realmID>/deposit

Content type:application/json
Production Base URL:https://quickbooks.api.intuit.com
Sandbox Base URL:https://sandbox-quickbooks.api.intuit.com

Request Body
{
  "Line": [
    {
      "DetailType": "DepositLineDetail", 
      "Amount": 20.0, 
      "ProjectRef": {
        "value": "42991284"
      }, 
      "DepositLineDetail": {
        "AccountRef": {
          "name": "Unapplied Cash Payment Income", 
          "value": "87"
        }
      }
    }
  ], 
  "DepositToAccountRef": {
    "name": "Checking", 
    "value": "35"
  }
}


Below are my associated tables

CREATE TABLE `undeposited_funds` (
  `id` int NOT NULL,
  `qb_txn_id` varchar(50) NOT NULL,
  `txn_type` varchar(50) DEFAULT NULL,
  `txn_date` date DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_ref_num` varchar(100) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `exchange_rate` decimal(8,6) DEFAULT NULL,
  `currency_ref_name` varchar(50) DEFAULT NULL,
  `ar_account_ref_name` varchar(255) DEFAULT NULL,
  `unapplied_amt` decimal(12,2) DEFAULT NULL,
  `debit_amount` decimal(14,2) DEFAULT NULL,
  `credit_amount` decimal(14,2) DEFAULT NULL,
  `je_description` text,
  `je_account_name` varchar(255) DEFAULT NULL,
  `je_line_name` varchar(255) DEFAULT NULL,
  `deposit_to_account` varchar(255) DEFAULT NULL,
  `refund_from_account` varchar(255) DEFAULT NULL,
  `is_deposited` tinyint(1) DEFAULT '0',
  `deposit_txn_id` varchar(50) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `memo` text,
  `line_items_json` longtext,
  `reference_number` varchar(100) DEFAULT NULL,
  `journal_reference` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `undeposited_funds_txn_lines`
--

CREATE TABLE `undeposited_funds_txn_lines` (
  `id` int NOT NULL,
  `uf_id` int NOT NULL,
  `txn_line_id` varchar(32) NOT NULL,
  `line_json` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;




