// public/js/undeposited_funds/make_bank_deposit.js

function reinitMakeBankDepositFeatures() {
    attachMakeBankDepositLogic();

    // Listen for dynamically (re)loaded "Make Bank Deposit" button
    const makeDepositBtn = document.getElementById('makeBankDepositBtn');
    if (makeDepositBtn && !makeDepositBtn.dataset.listenerAttached) {
        makeDepositBtn.addEventListener('click', async () => {
            await loadView('/undepositedfunds/loadView?view_mode=make_bank_deposit', 'middlePane');
            await loadView('/undepositedfunds/left/make_bank_deposit', 'leftPane');
        });
        makeDepositBtn.dataset.listenerAttached = 'true';
    }
}

document.addEventListener('DOMContentLoaded', reinitMakeBankDepositFeatures);

async function loadView(url, paneId) {
    try {
        const resp = await fetch(url);
        if (!resp.ok) throw new Error(`HTTP error! status: ${resp.status}`);
        const html = await resp.text();
        document.getElementById(paneId).innerHTML = html;

        // After any AJAX load, re-initialize all event logic and sum
        reinitMakeBankDepositFeatures();
        updateSelectedAmount();
    } catch (error) {
        console.error('loadView error:', error);
    }
}

function attachMakeBankDepositLogic() {
    const middlePane = document.getElementById('middlePane');
    if (!middlePane) return;
    const checkboxes = middlePane.querySelectorAll('input[type="checkbox"][name="depositCheckbox[]"]');
    checkboxes.forEach(checkbox => {
        // Remove previous event listeners by cloning the node
        const newCheckbox = checkbox.cloneNode(true);
        checkbox.parentNode.replaceChild(newCheckbox, checkbox);

        newCheckbox.addEventListener('change', async (e) => {
            const checked = e.target.checked;
            const ufId = e.target.value;
            try {
                const res = await fetch('/undepositedfunds/updateSelected', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ ufId, checked })
                });
                if (!res.ok) throw new Error('Failed to update selection');
            } catch (err) {
                console.error('Error updating selection:', err);
            }
            updateSelectedAmount();
        });
    });

    // Listen for red "X" to clear selection and reload sidebar
    const leftPane = document.getElementById('leftPane');
    if (leftPane) {
        const closeBtn = leftPane.querySelector('#closeMakeDepositBtn');
        if (closeBtn && !closeBtn.dataset.listenerAttached) {
            closeBtn.addEventListener('click', async () => {
                const response = await fetch('/undepositedfunds/clearSelected', { method: 'POST' });
                if (!response.ok) {
                    console.error('Session clearing failed', response);
                    return;
                }
                const html = await response.text();
                leftPane.innerHTML = html;
                // After reload, re-init logic
                reinitMakeBankDepositFeatures();
                updateSelectedAmount();
            });
            closeBtn.dataset.listenerAttached = 'true';
        }
    }

    updateSelectedAmount();
}

function updateSelectedAmount() {
    const middlePane = document.getElementById('middlePane');
    const checkboxes = middlePane ? middlePane.querySelectorAll('input[type="checkbox"][name="depositCheckbox[]"]:checked') : [];
    let sum = 0;

    checkboxes.forEach(box => {
        const amountAttr = box.getAttribute('data-amount');
        let amount = parseFloat(amountAttr);
        if (isNaN(amount)) amount = 0;
        sum += amount;
    });

    const leftPane = document.getElementById('leftPane');
    const display = leftPane ? leftPane.querySelector('#amountSelectedDisplay') : null;
    console.log('SUM DEBUG:', sum, 'DISPLAY:', display, 'LEFT PANE:', leftPane);

    if (display) {
        const formatted = sum < 0
            ? `-\$${Math.abs(sum).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}`
            : `\$${sum.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}`;
        display.textContent = formatted;
    }
}

