// dealcommissions.js
$(document).ready(function() {
    // Recalc once on load
    recalcTable();
  
    // Whenever the user changes any of the 4 Payout % fields:
    $('#deposit, #customer_care, #title_work, #checkout_completed').on('input', function() {
      recalcTable();
    });
  });
  
  function recalcTable() {
    // 1) Get the 4 current percent values
    let depositPercent  = parseFloat($('#deposit').val()) || 0;
    let carePercent     = parseFloat($('#customer_care').val()) || 0;
    let titlePercent    = parseFloat($('#title_work').val()) || 0;
    let checkoutPercent = parseFloat($('#checkout_completed').val()) || 0;
  
    // 2a) Update "Deposit" cells
    document.querySelectorAll('.deposit-cell').forEach(td => {
      let userName    = td.dataset.username;      // e.g. "Mark Diem"
      let grossProfit = parseFloat(td.dataset.grossProfit) || 0;
      let payout      = grossProfit * (depositPercent / 100);
      td.textContent  = userName ? (userName + ' - $' + payout.toFixed(2)) : '';
    });
  
    // 2b) Customer Care
    document.querySelectorAll('.care-cell').forEach(td => {
      let userName    = td.dataset.username;
      let grossProfit = parseFloat(td.dataset.grossProfit) || 0;
      let payout      = grossProfit * (carePercent / 100);
      td.textContent  = userName ? (userName + ' - $' + payout.toFixed(2)) : '';
    });
  
    // 2c) Title Work
    document.querySelectorAll('.title-cell').forEach(td => {
      let userName    = td.dataset.username;
      let grossProfit = parseFloat(td.dataset.grossProfit) || 0;
      let payout      = grossProfit * (titlePercent / 100);
      td.textContent  = userName ? (userName + ' - $' + payout.toFixed(2)) : '';
    });
  
    // 2d) Checkout Completed
    document.querySelectorAll('.checkout-cell').forEach(td => {
      let userName    = td.dataset.username;
      let grossProfit = parseFloat(td.dataset.grossProfit) || 0;
      let payout      = grossProfit * (checkoutPercent / 100);
      td.textContent  = userName ? (userName + ' - $' + payout.toFixed(2)) : '';
    });
  }
  