<!DOCTYPE html>
<html lang="en">
<head>
    <?= view('shared/head') ?>
    <link rel="stylesheet" type="text/css" href="<?= base_url('css/library.css') ?>">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <style>
        .content-wrapper {
            min-height: 100vh;
            background: #f8f9fa;
            padding: 20px;
        }
        .modal-dialog-scrollable .modal-body {
            max-height: 70vh;
            overflow-y: auto;
        }
        td[data-field="notes"] {
            cursor: pointer;
        }
    </style>
</head>
<body>
<div class="wrapper">

    <!-- Navbar / Left Sidebar -->
    <?= view('layouts/navbar', ['menuItems' => $menuItems]) ?>

    <!-- Page Content -->
    <div class="content-wrapper text-navy">
        <!-- Heading + Connect Button -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="mb-0">Audit QuickBooks - Pull &amp; Process Data</h1>
            
            <?php if (!$isConnected): ?>
                <!-- Show Connect button if not connected -->
                <a href="<?= base_url('qboauth/connect') ?>" class="btn btn-success">
                    Connect to QuickBooks
                </a>
            <?php else: ?>
                <!-- Show a simple status if already connected -->
                <span class="text-success">Connected to QuickBooks</span>
            <?php endif; ?>
        </div>

        <!-- Display error if any -->
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger">
                <?= esc($error) ?>
            </div>
        <?php endif; ?>

        <!-- Main Form -->
        <form method="post" action="<?= base_url('auditquickbooks') ?>" class="mb-3">

            <!-- Date Range -->
            <div class="form-row">
                <div class="col-sm-2">
                    <label for="from_date">From</label>
                    <input
                        type="date"
                        name="from_date"
                        id="from_date"
                        class="form-control"
                        value="<?= esc($from_date) ?>"
                    />
                </div>
                <div class="col-sm-2">
                    <label for="to_date">To</label>
                    <input
                        type="date"
                        name="to_date"
                        id="to_date"
                        class="form-control"
                        value="<?= esc($to_date) ?>"
                    />
                </div>

                <!-- Hidden amazon_visible field -->
                <input type="hidden" name="amazon_visible" value="<?= $amazon_visible ? '1' : '0' ?>">

                <!-- View dropdown partial -->
                <div class="col-sm-3">
                    <?= view('auditquickbooks/_view_select_dropdown', [
                        'view_select' => $view_select ?? 'pull',
                    ]) ?>
                </div>
            </div>

            <!-- Buttons Row -->
            <div class="form-row mt-3">
                <!-- Fetch Sales Receipts -->
                <div class="col-auto">
                    <button class="btn btn-primary" type="submit" name="action" value="fetch">
                        Fetch Sales Receipts
                    </button>
                </div>
                <!-- Fetch Journal Entries -->
                <div class="col-auto">
                    <button class="btn btn-info" type="submit" name="action" value="fetch_journal">
                        Fetch Journal Entries
                    </button>
                </div>
                <!-- Populate/Audit JE&SR -->
                <div class="col-auto">
                    <button class="btn btn-warning" type="submit" name="action" value="audit_populate">
                        Populate/Audit JE&amp;SR
                    </button>
                </div>
                <!-- Toggle Amazon button -->
                <div class="col-auto">
                    <button class="btn btn-secondary" type="submit" name="action" value="toggle_amazon">
                        <?= $amazon_visible ? 'Hide Amazon' : 'Show Amazon' ?>
                    </button>
                </div>
                <!-- Unique Debit & Credit Accounts -->
                <div class="col-auto">
                    <button class="btn btn-dark" type="submit" name="action" value="unique_accounts">
                        Unique Debit &amp; Credit Accounts
                    </button>
                </div>
            </div>
        </form>

        <!-- If we have dbResults, display them here -->
        <?php if (!empty($dbResults)): ?>
            <div class="table-responsive mt-4">
                <table class="table table-bordered table-striped bg-white">
                    <thead class="thead-dark">
                    <tr>
                        <th>ID</th>
                        <th>QB ID</th>
                        <th>Inv No</th> <!-- Renamed column header -->
                        <th>Txn Date (createdat)</th>
                        <th>Total Amt</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($dbResults as $row): ?>
                        <tr>
                            <td><?= esc($row['id']) ?></td>
                            <td><?= esc($row['qb_id']) ?></td>
                            <!-- Changed from doc_number to inv_no -->
                            <td><?= esc($row['doc_number']) ?></td>
                            <td><?= esc($row['txn_date']) ?></td>
                            <td><?= esc($row['total_amt']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="mt-4">No Sales Receipts found for the selected date range.</p>
        <?php endif; ?>

        <!-- Unique Debit/Credit Accounts if available -->
        <?php if (!empty($uniqueDebit) || !empty($uniqueCredit)):
            $maxRows = max(count($uniqueDebit), count($uniqueCredit));
        ?>
            <hr/>
            <h3>Unique Debit &amp; Credit Accounts</h3>
            <div class="table-responsive">
                <table class="table table-bordered bg-white">
                    <thead class="thead-light">
                        <tr>
                            <th>Debit Accounts</th>
                            <th>Credit Accounts</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php for ($i = 0; $i < $maxRows; $i++): ?>
                        <tr>
                            <td><?= isset($uniqueDebit[$i]) ? esc($uniqueDebit[$i]) : '' ?></td>
                            <td><?= isset($uniqueCredit[$i]) ? esc($uniqueCredit[$i]) : '' ?></td>
                        </tr>
                    <?php endfor; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>

    </div><!-- /.content-wrapper -->
</div><!-- /.wrapper -->

<!-- jQuery + Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
