<?php
// app/Views/undepositedfunds/middle/manage_undeposited_funds.php
?>

<!-- Optional heading -->
<h2>Undeposited Funds</h2>

<!-- Date range form -->
<form method="get" action="<?= base_url('undepositedfunds') ?>" class="date-form">
    <div class="date-group">
        <label for="from_date">From Date:</label>
        <input type="date" id="from_date" name="from_date" value="<?= esc($from_date) ?>">
    </div>

    <div class="date-group">
        <label for="to_date">To Date:</label>
        <input type="date" id="to_date" name="to_date" value="<?= esc($to_date) ?>">
    </div>

    <button type="submit">Search</button>
</form>

<?php if (! empty($results)): ?>
    <table class="uf-table">
        <thead>
            <tr>
                <th>Customer</th>
                <th>Transaction Date</th>
                <th>Amount</th>
                <th>Type</th>
                <th>Deposited</th>
                <th>Date Deposited</th>
                <th>QB Deposit ID</th>
                <th>Memo</th>
                <th>Reference</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <?php
                    // Determine icon
                    $isDeposited = (int) $row['is_deposited'];
                    $iconHtml = ($isDeposited === 1)
                        ? '<span class="check-icon">&#x2705;</span>'   // circle green check
                        : '<span class="x-icon">&#x274C;</span>';      // circle red X

                    // Format deposit date
                    $depositDate = $row['deposit_date'] ?? null;
                    $formattedDate = $depositDate ? date('m/d/Y', strtotime($depositDate)) : '';

                    // QB deposit link
                    $depositTxnId = $row['deposit_txn_id'] ?? '';

                    // Determine link for txn_type
                    $txnType = $row['txn_type'] ?? '';
                    $txnId   = $row['qb_txn_id'] ?? '';
                    $typeLink = '';
                    if ($txnType === 'JournalEntry') {
                        $typeLink = "https://qbo.intuit.com/app/journal?txnId={$txnId}";
                    } elseif ($txnType === 'SalesReceipt') {
                        $typeLink = "https://qbo.intuit.com/app/salesreceipt?txnId={$txnId}";
                    } elseif ($txnType === 'Payment') {
                        $typeLink = "https://qbo.intuit.com/app/recvpayment?txnId={$txnId}";
                    }
                ?>
                <tr>
                    <td>
                        <div class="truncate-customer">
                            <?= esc($row['customer_name']) ?>
                        </div>
                    </td>
                    <td><?= esc($row['txn_date']) ?></td>
                    <td><?= esc($row['amount']) ?></td>

                    <td>
                        <?php if ($typeLink): ?>
                            <a href="<?= $typeLink ?>" target="_blank">
                                <?= esc($txnType) ?>
                            </a>
                        <?php else: ?>
                            <?= esc($txnType) ?>
                        <?php endif; ?>
                    </td>

                    <td><?= $iconHtml ?></td>
                    <td><?= esc($formattedDate) ?></td>
                    <td>
                        <?php if (!empty($depositTxnId)): ?>
                            <a href="https://qbo.intuit.com/app/deposit?txnId=<?= esc($depositTxnId) ?>" target="_blank">
                                <?= esc($depositTxnId) ?>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="truncate-memo">
                            <?= esc($row['memo']) ?>
                        </div>
                    </td>
                    <td>
                        <div class="truncate-reference">
                            <?= esc($row['reference_number']) ?>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>No undeposited funds found.</p>
<?php endif; ?>
